;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB) -*- 

;1;; INSTRUCTIONS for EXAMPLES in this FILE:*
;1;;     * Compile and load this file.  For example, if you are reading this in a Zmacs buffer, then use META-Z.*
;1;;     * Make sure the default TB Server is running, enter *(tb:launch-default-tb-server t)1 in a*
;1;;        listener.  (You will have to click on the microExplorer window to reselect it after the launch.)*
;1;;     * Shrink the microExplorer window until it occupies the lower half of the screen leaving the upper half*
;1;;        free for the window  some of these examples create. *
;1;;     * Enter a call to the example function in a listener*
;1;;     * The call should display a dialog box which may be partially obscured by you microExplorer window.*
;1;;       Just click on the dialog box to bring it to the front.*
;1;;     * When you have made your choices in the dialog box and clicked on either OPEN or CANCEL, the*
;1;;       example function returns, but you will have to click once again on the microExplorer window to make*
;1;;       it active.*


(defun 4MacGetFile *(&rest typenames)
  "2Displays a dialog box of available disks, folders, and files for user to choose
from. Argument is zero or more Macintosh file types (see III-9) which are four
character strings.  Note:  these Macintosh `file types' are unrelated to the type
component of Common Lisp pathnames.  If no typenames are specified, then any file
type is acceptable.    If user clicks CANCEL, GOOD-P is false.  Otherwise, GOOD-P
is true and the volume reference number and the file name are returned.*"
  (declare (values 3good-p |vRefNum| |fName|*))
  (let ((typename-count (or (length typenames) -1))
	(reply         (make-instance 'SFReply))
	(point (make-instance 'point :h 160 :v 100)))
    (!SFGetFile point           ;1 upper left corner of dialog box in global coordinates*
		""              ;1 prompt argument is no longer used by the Macintosh*
		!nilptr	        ;1 fileFilter argument not available yet, always use !nilPtr*
		typename-count	;1 count of file type names or -1 to imply all type names*
		typenames       ;1 list of 0..4 4-character file type name strings, or NIL for all types*
		!nilptr         ;1 dlgHook argument not available yet, always use !nilPtr*
		reply)          ;1 SFReply instance in which return values will be stored*
    (values reply                  ;1SFReply instance*
	    (send reply :good) 3 *   ;1true=>user clicked on OPEN;  false=>clicked on CANCEL*
            (send reply :vRefNum)  ;1volume reference number of disk/diredirectory*
	    (send reply :fName)))  ;1file name string (includes Lisp name and type components)*
  );1;macgetfile*


(defun 4MacPutFile *(prompt-string &optional default-fname)
  "2Prompts the user with a dialog box asking for an output filename.  Returns when
user clicks on CANCEL (GOOD-P false) or when user clicks on OPEN (GOOD-P true)
after having specified a non-lock file which does not yet exist or for which the
user has given permission to replace.*"
  (declare (values reply good-p |3vRefNum|* |3fName|*))
  (check-type prompt-string string)
  (check-type default-fname (or null string))
  (let ((reply (make-instance 'SFReply))
	(point (make-instance 'point :h 160 :v 100)))
    (!SFPutFile point           ;1 upper left corner of dialog box in global coordinates*
		prompt-string   ;1 a prompt string explaining what the filename is needed for*
		(or default-fname ;1 a default filename for the user to accept or edit*
		    "")
		!nilptr         ;1 dlgHook argument not available yet, always use !nilPtr*
		reply)          ;1 SFReply instance in which return values will be stored*
    (values reply                  ;1SFReply instance*
	    (send reply :good) 3 *   ;1true=>user clicked on OPEN;  false=>clicked on CANCEL*
	    (send reply :vRefNum)  ;1volume reference number of disk/diredirectory*
	    (send reply :fName)))  ;1file name string (includes Lisp name and type components)*
  );1;macputfile*


(defun 4OpenResFile *()
  (declare (values |3resFile-refNum|*))
  (let ((reply (make-instance 'SFReply))
	(point (make-instance 'point :h 160 :v 100)))
    (!SFGetFile point "" !nilptr -1 () !nilptr reply)
    (!flushevents !everyEvent 0)
    (if (send reply :good)
	(!OpenRFPerm  (send reply :fname) (send reply :vrefnum) !fsCurPerm)
	nil))
  );1;openresfile












